if (!("finalizeConstruction" in ViewPU.prototype)) {
    Reflect.set(ViewPU.prototype, "finalizeConstruction", () => { });
}
interface MusicRelax_Params {
    musicList?: string[];
    selectedMusic?: string;
    isPlaying?: boolean;
    volume?: number;
}
import router from "@ohos:router";
class MusicRelax extends ViewPU {
    constructor(parent, params, __localStorage, elmtId = -1, paramsLambda = undefined, extraInfo) {
        super(parent, __localStorage, elmtId, extraInfo);
        if (typeof paramsLambda === "function") {
            this.paramsGenerator_ = paramsLambda;
        }
        this.__musicList = new ObservedPropertyObjectPU(['自然白噪音', '放松钢琴曲', '冥想音乐', '海洋之声', '森林鸟鸣'], this, "musicList");
        this.__selectedMusic = new ObservedPropertySimplePU('自然白噪音', this, "selectedMusic");
        this.__isPlaying = new ObservedPropertySimplePU(false, this, "isPlaying");
        this.__volume = new ObservedPropertySimplePU(50, this, "volume");
        this.setInitiallyProvidedValue(params);
        this.finalizeConstruction();
    }
    setInitiallyProvidedValue(params: MusicRelax_Params) {
        if (params.musicList !== undefined) {
            this.musicList = params.musicList;
        }
        if (params.selectedMusic !== undefined) {
            this.selectedMusic = params.selectedMusic;
        }
        if (params.isPlaying !== undefined) {
            this.isPlaying = params.isPlaying;
        }
        if (params.volume !== undefined) {
            this.volume = params.volume;
        }
    }
    updateStateVars(params: MusicRelax_Params) {
    }
    purgeVariableDependenciesOnElmtId(rmElmtId) {
        this.__musicList.purgeDependencyOnElmtId(rmElmtId);
        this.__selectedMusic.purgeDependencyOnElmtId(rmElmtId);
        this.__isPlaying.purgeDependencyOnElmtId(rmElmtId);
        this.__volume.purgeDependencyOnElmtId(rmElmtId);
    }
    aboutToBeDeleted() {
        this.__musicList.aboutToBeDeleted();
        this.__selectedMusic.aboutToBeDeleted();
        this.__isPlaying.aboutToBeDeleted();
        this.__volume.aboutToBeDeleted();
        SubscriberManager.Get().delete(this.id__());
        this.aboutToBeDeletedInternal();
    }
    private __musicList: ObservedPropertyObjectPU<string[]>;
    get musicList() {
        return this.__musicList.get();
    }
    set musicList(newValue: string[]) {
        this.__musicList.set(newValue);
    }
    private __selectedMusic: ObservedPropertySimplePU<string>;
    get selectedMusic() {
        return this.__selectedMusic.get();
    }
    set selectedMusic(newValue: string) {
        this.__selectedMusic.set(newValue);
    }
    private __isPlaying: ObservedPropertySimplePU<boolean>;
    get isPlaying() {
        return this.__isPlaying.get();
    }
    set isPlaying(newValue: boolean) {
        this.__isPlaying.set(newValue);
    }
    private __volume: ObservedPropertySimplePU<number>;
    get volume() {
        return this.__volume.get();
    }
    set volume(newValue: number) {
        this.__volume.set(newValue);
    }
    aboutToAppear(): void {
        // 页面显示时的初始化
    }
    aboutToDisappear(): void {
        // 页面隐藏时停止播放
        this.stopPlayback();
    }
    togglePlayback(): void {
        this.isPlaying = !this.isPlaying;
        // 这里可以添加实际的音频播放逻辑
    }
    stopPlayback(): void {
        this.isPlaying = false;
        // 停止音频播放
    }
    initialRender() {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create({ space: 20 });
            Column.width('100%');
            Column.height('100%');
            Column.padding(20);
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('音乐放松');
            Text.fontSize(24);
            Text.fontWeight(FontWeight.Bold);
            Text.margin({ bottom: 30 });
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 音乐播放控制
            Column.create({ space: 15 });
            // 音乐播放控制
            Column.width('90%');
            // 音乐播放控制
            Column.padding(20);
            // 音乐播放控制
            Column.backgroundColor('#F8F8F8');
            // 音乐播放控制
            Column.borderRadius(12);
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create(this.selectedMusic);
            Text.fontSize(20);
            Text.fontWeight(FontWeight.Medium);
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.justifyContent(FlexAlign.Center);
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel(this.isPlaying ? '暂停' : '播放');
            Button.type(ButtonType.Capsule);
            Button.width(100);
            Button.height(40);
            Button.backgroundColor(this.isPlaying ? '#FF3B30' : '#34C759');
            Button.fontColor('#FFFFFF');
            Button.onClick(() => this.togglePlayback());
        }, Button);
        Button.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            If.create();
            if (this.isPlaying) {
                this.ifElseBranchUpdateFunction(0, () => {
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Button.createWithLabel('停止');
                        Button.type(ButtonType.Normal);
                        Button.width(80);
                        Button.height(40);
                        Button.margin({ left: 10 });
                        Button.onClick(() => this.stopPlayback());
                    }, Button);
                    Button.pop();
                });
            }
            else {
                this.ifElseBranchUpdateFunction(1, () => {
                });
            }
        }, If);
        If.pop();
        Row.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 音量控制
            Row.create();
            // 音量控制
            Row.width('100%');
            // 音量控制
            Row.padding(10);
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('音量:');
            Text.fontSize(14);
            Text.width(60);
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Slider.create({
                value: this.volume,
                min: 0,
                max: 100
            });
            Slider.width('70%');
            Slider.onChange((value: number) => {
                this.volume = value;
            });
        }, Slider);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create(`${this.volume}%`);
            Text.fontSize(14);
            Text.width(40);
        }, Text);
        Text.pop();
        // 音量控制
        Row.pop();
        // 音乐播放控制
        Column.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 音乐列表
            Text.create('选择音乐');
            // 音乐列表
            Text.fontSize(18);
            // 音乐列表
            Text.fontWeight(FontWeight.Medium);
            // 音乐列表
            Text.width('100%');
            // 音乐列表
            Text.textAlign(TextAlign.Start);
            // 音乐列表
            Text.margin({ top: 20, bottom: 10 });
        }, Text);
        // 音乐列表
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            List.create({ space: 10 });
            List.width('100%');
            List.height('100%');
            List.layoutWeight(1);
        }, List);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            ForEach.create();
            const forEachItemGenFunction = _item => {
                const music = _item;
                {
                    const itemCreation = (elmtId, isInitialRender) => {
                        ViewStackProcessor.StartGetAccessRecordingFor(elmtId);
                        itemCreation2(elmtId, isInitialRender);
                        if (!isInitialRender) {
                            ListItem.pop();
                        }
                        ViewStackProcessor.StopGetAccessRecording();
                    };
                    const itemCreation2 = (elmtId, isInitialRender) => {
                        ListItem.create(deepRenderFunction, true);
                        ListItem.onClick(() => {
                            this.selectedMusic = music;
                            if (this.isPlaying) {
                                // 切换音乐时重新开始播放
                                this.stopPlayback();
                                setTimeout((): void => this.togglePlayback(), 100); // ✅ 修正：添加返回类型
                            }
                        });
                    };
                    const deepRenderFunction = (elmtId, isInitialRender) => {
                        itemCreation(elmtId, isInitialRender);
                        this.observeComponentCreation2((elmtId, isInitialRender) => {
                            Row.create();
                            Row.width('100%');
                            Row.padding(15);
                            Row.backgroundColor(this.selectedMusic === music ? '#E3F2FD' : '#FFFFFF');
                            Row.borderRadius(8);
                        }, Row);
                        this.observeComponentCreation2((elmtId, isInitialRender) => {
                            Text.create(music);
                            Text.fontSize(16);
                            Text.layoutWeight(1);
                        }, Text);
                        Text.pop();
                        Row.pop();
                        ListItem.pop();
                    };
                    this.observeComponentCreation2(itemCreation2, ListItem);
                    ListItem.pop();
                }
            };
            this.forEachUpdateFunction(elmtId, this.musicList, forEachItemGenFunction);
        }, ForEach);
        ForEach.pop();
        List.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel('返回主页');
            Button.type(ButtonType.Normal);
            Button.width('90%');
            Button.height(45);
            Button.onClick(() => {
                router.back();
            });
        }, Button);
        Button.pop();
        Column.pop();
    }
    rerender() {
        this.updateDirtyElements();
    }
    static getEntryName(): string {
        return "MusicRelax";
    }
}
registerNamedRoute(() => new MusicRelax(undefined, {}), "", { bundleName: "com.example.myapplication", moduleName: "entry", pagePath: "pages/MusicRelax", pageFullPath: "entry/src/main/ets/pages/MusicRelax", integratedHsp: "false" });
